; ******************************************************
;               DC mBOT - Weather Bot
; ******************************************************
on *:Text:*weather*:#: {
  if (%Extra-Set == OFF) halt
  if ($1 == %Trigger $+ weather) && (%Weather-Cmd == ON) {
    if (!$sock(weather)) {
      set %weatherurl /cgi-bin/findweather/getForecast?query= $+ $replace($2-,$chr(32),+)
      set %whchan $chan
      weatherlookup
    }
    else { msg $chan Weather Bot is currently busy... }
  }
}

alias weatherlookup { sockopen weather wunderground.com 80 }
alias remhtml { var %x,%y = $regsub($1-,/(<[^>]+>)/g,$null,%x) | var %x = $replace(%x,&nbsp;,$chr(32),&#176;,$chr(176),&deg;,$chr(176)) | return %x }
alias processweatherwindow {
  set %wht_location $gettok($line(@weather,1),3-6,32)
  set %wht_update $gettok($line(@weather,$fline(@weather,*Updated:*)),2-7,32) $left($gettok($line(@weather,$fline(@weather,*Updated:*)),8,32),4)
  set %wht_tempF $remove($line(@weather,$calc($fline(@weather,Temperature) + 1)),$chr(32))
  set %wht_tempC $remove($line(@weather,$calc($fline(@weather,Temperature) + 3)),$chr32))
  set %wht_humid $line(@weather,$calc($fline(@weather,Humidity) + 1))
  set %wht_windD $line(@weather,$calc($fline(@weather,Wind) + 1))
  set %wht_windM $line(@weather,$calc($fline(@weather,Wind) + 2))
  set %wht_windK $line(@weather,$calc($fline(@weather,Wind) + 4))
  set %wht_cond $line(@weather,$calc($fline(@weather,Conditions) + 1))
  msg %whchan $+(,%wht_location,,$chr(32),$chr(40),%wht_update,$chr(41))
  msg %whchan $+(Temperature:,$chr(32),%wht_tempF,$chr(32),/,$chr(32),%wht_tempC,$chr(32),Current Conditions:,$chr(32),%wht_cond) / $+(Humidity:,$chr(32),%wht_humid,$chr(32),Wind:,$chr(32),%wht_windD,$chr(32),%wht_windM,$chr(32),/,$chr(32),%wht_windK)
  window -c @weather
  unset %weatherurl %weatherresult %whchan %wht_*
}

on *:SOCKOPEN:weather: {
  sockwrite -nt $sockname GET %weatherurl HTTP/1.1
  sockwrite -nt $sockname Accept-Language: en-us
  sockwrite -nt $sockname User-Agent: Mozilla/5.0 (Windows; U; Windows NT 5.2; rv:1.7.3) Gecko/20040913 Firefox/0.10.1
  sockwrite -nt $sockname Host: printer.wunderground.com
  sockwrite -nt $sockname Connection: Keep-Alive
  sockwrite -t $sockname $str($crlf,2)
}
on 1:sockread:weather: {
  window @weather
  if ($sockerr > 0) return
  :nextread
  sockread %weatherresult
  if ($sockbr == 0) return
  if (%weatherresult == $null) { %weatherresult = - }
  if (*map type* iswm %weatherresult) { 
    msg %whchan There are more results matching your Query. Please narrow your search.
    sockclose weather
    window -c @weather
    return
  }
  if *Click on a city name for the forecast* iswm %weatherresult { 
    msg %whchan There are more results matching your Query. Please narrow your search.
    sockclose weather
    window -c @weather
    return
  }
  if (*City Not Found* iswm %weatherresult) { 
    msg %whchan Sorry, Couldn't found any match about yhat city.
    sockclose weather
    window -c @weather
    return
  }
  if (*Forecast and Conditions for* iswm %weatherresult) { .enable #addline | .disable #noline }
  if (*Forecast as of* iswm %weatherresult) { .disable #addline | .enable #noline | sockclose weather | processweatherwindow }
  $$addlines(%weatherresult)
  echo -s %weatherresult
  goto nextread
}

#addline off
alias addlines {
  if ($1- == $null) || ($remhtml($1-) == $null) { .echo -q null | return }
  else { aline -p @weather $remhtml($1-) }
}
#addline end

#noline on
alias addlines { .echo -q 0 }
#noline end
